import React, { useState, useEffect } from 'react';
import './CurrencyConverter.css';
function CurrencyDropdown({ currencies, selectedCurrency, setSelectedCurrency }) {
  return (
    <select value={selectedCurrency} onChange={(e) => setSelectedCurrency(e.target.value)}>
      <option value="" disabled>
        Select Currency
      </option>
      {currencies.map(([code, name]) => (
        <option key={code} value={code}>
          {name} ({code})
        </option>
      ))}
    </select>
  );
}

function CurrencyConverter() {
  const [currencies, setCurrencies] = useState([]);
  const [amount, setAmount] = useState(1);
  const [fromCurrency, setFromCurrency] = useState('');
  const [toCurrency, setToCurrency] = useState('');
  const [convertedAmount, setConvertedAmount] = useState(null);

  useEffect(() => {
    const fetchCurrencies = async () => {
      try {
        const response = await fetch('https://api.frankfurter.app/currencies');
        const data = await response.json();
        setCurrencies(Object.entries(data));
      } catch (error) {
        console.error('Error fetching currencies:', error);
      }
    };

    fetchCurrencies();
  }, []);

  const handleConvert = async () => {
    if (!fromCurrency || !toCurrency) {
      alert('Please select both currencies.');
      return;
    }
    try {
      const response = await fetch(
        `https://api.frankfurter.app/latest?amount=${amount}&from=${fromCurrency}&to=${toCurrency}`
      );
      const data = await response.json();
      setConvertedAmount(data.rates[toCurrency]);
    } catch (error) {
      console.error('Error converting currency:', error);
    }
  };

  return (
    <div>
      <h1>Currency Converter</h1>
      <p>By Mats and Artur</p>
      <div>
        <label>
          Amount:
          <input
            type="number"
            value={amount}
            onChange={(e) => setAmount(Number(e.target.value))}
            min="1"
          />
        </label>
      </div>
      <div>
        <label>
          From:
          <CurrencyDropdown
            currencies={currencies}
            selectedCurrency={fromCurrency}
            setSelectedCurrency={setFromCurrency}
          />
        </label>
      </div>
      <div>
        <label>
          To:
          <CurrencyDropdown
            currencies={currencies}
            selectedCurrency={toCurrency}
            setSelectedCurrency={setToCurrency}
          />
        </label>
      </div>
      <button onClick={handleConvert}>Convert</button>
      {convertedAmount !== null && (
        <p>
          {amount} {fromCurrency} = {convertedAmount.toFixed(2)} {toCurrency}
        </p>
      )}
    </div>
  );
}

export default CurrencyConverter;
